<?php
session_start();
include("../config.php");
include(appPath."/includes/auth.php");
require_once(appPath."/includes/dbconn.php");

$tableName1 = "users_qrcode";
$userId = $_SESSION['userid'];

if(!isset($_POST['action'])) {
	header("HTTP/1.1 403 Forbidden" );
	die('Forbidden');
}

function validate() {
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($_POST['content'] == '') {
			$data['inputerror'][] = 'content';
			$data['error_string'][] = 'Content required';
			$data['status'] = FALSE;
		}

		if($data['status'] === FALSE) {
			echo json_encode($data);
			exit();
		}
}

if($_POST['action'] == "list") {
	## Read value
	$start = $_POST['start'];
	$rowperpage = $_POST['length']; // Rows display per page
	if(isset($_POST['order'])) {
		$columnIndex = $_POST['order'][0]['column']; // Column index
		$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	} else {
		$columnIndex = '1';
		$columnName = 'id';
		$columnSortOrder = 'desc';
	}

	## Search
	$column_search = $db->rawQuery("SHOW COLUMNS FROM $tableName1");
	foreach($column_search as $fieds) {
		$colResult[] = $fieds['Field']; 
	}
	
	$searchQuery = "";
	if($_POST['search']['value']) {
		$i = 0;
		$searchQuery = "";
		foreach($colResult as $col) {
			if($i===0) { // first loop
				$searchQuery .= "AND ($col LIKE '%".$_POST['search']['value']."%' ";
			} else {
				$searchQuery .= "OR $col LIKE '%".$_POST['search']['value']."%' ";
			}
			if(count($colResult) - 1 == $i) { //last loop
				$searchQuery .= ")";
			}
			$i++;
		}
	}
	
	## Total number of records without filtering
	$records=$db->rawQueryOne("SELECT count(*) as allcount FROM $tableName1 WHERE userId=$userId");
	$totalRecords = $records['allcount'];
	
	## Total number of record with filtering
	$records=$db->rawQueryOne("SELECT count(*) as allcount FROM $tableName1 WHERE userId=$userId ".$searchQuery);
	$totalRecordwithFilter = $records['allcount'];
	
	## Fetch records
	$result=$db->rawQuery("SELECT * FROM $tableName1 WHERE userId=$userId ".$searchQuery." order by ".$columnName." ".$columnSortOrder." limit ".$start.",".$rowperpage);
	$data = array();
	foreach($result as $line) {
		$row = array();
		$row[] = '<input type="checkbox" name="row" id="check_'.$line['id'].'" value="'.$line['id'].'" class="checkbox"/>';
		$row[] = $line['id'];
		$row[] = $line['date'];
		$row[] = $line['content'];
		//add html for action
		$row[] = '<div class="btn-group btn-group-sm">
			<a href="javascript:void(0)" title="View" onclick="view_row('."'".$line['id']."'".')" class="btn btn-primary"><i class="fas fa-eye"></i></a>
			<a href="edit.php?id='.$line['id'].'" title="Edit" class="btn btn-success"><i class="fas fa-edit"></i></a>
			</div>';
		$data[] = $row;
	}

	## Response
	$output = array(
		"draw" => $_POST['draw'],
		"recordsTotal" => $totalRecords,
		"recordsFiltered" => $totalRecordwithFilter,
		"data" => $data,
					);
	//output to json format
	echo json_encode($output);

//ajax view
} elseif($_POST['action'] == "view") {
	$row_id=$_POST['id'];
	$result=$db->rawQueryOne("SELECT * from  $tableName1 WHERE userId=$userId AND id=$row_id");
	$output['col'] = $result;
	echo json_encode($output);

//ajax delete
} elseif($_POST['action'] == "delete") {
	$totalCount = $successCount = 0;
	if(isset($_POST['ids'])) {
		foreach($_POST['ids'] as $row) {
			$totalCount++;
			$db->where('id', $row['value']);
			$db->where('userId', $userId);
			if($db->delete("$tableName1")) {
				$successCount++; 
			}
		}
		echo json_encode(array("status" => TRUE, "msg" => "$totalCount of $successCount Record Deleted"));
	} else {
		echo json_encode(array("status" => FALSE, "msg" => "Error"));
	}

//ajax update
} elseif($_POST['action'] == "update") {
		validate();
		if($_POST['id'] != "") {
			$content = $_POST['content'];
			$data = Array ('content' => "$content");
			$db->where('id', $_POST['id']);
			$db->where('userid', $userId);
			$db->update("$tableName1", $data);
			$_SESSION["message"] = "Data updated successfully";
			echo json_encode(array("status" => TRUE, "msg" => "Success"));
		} else {
			echo json_encode(array("status" => FALSE, "msg" => "Error"));
		}

//ajax add
} elseif($_POST['action'] == "add") {
		validate();
		if($_POST['content'] != "") {
			$content = $_POST['content'];
			$shareId = pass_encrypt(randomString());
			$data = Array ( 'userId' => "$userId", 'shareId' => "$shareId", 'date' => "$date", 'content' => "$content");
			$insert_id = $db->insert("$tableName1", $data);
			echo json_encode(array("status" => TRUE, "msg" => "Success", "shareId" => "$shareId"));
		} else {
			echo json_encode(array("status" => FALSE, "msg" => "Error"));
		}
//ajax error
}	else {
	echo json_encode("Error");
}
?>