<?php
session_start();
include("../config.php");
include(adminPath."/includes/auth.php");
require_once(appPath."/includes/dbconn.php");

$pageTitle = "Blog";
include("../__header.php");
include("../__menu.php");
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4"><?php echo $pageTitle;?></h1>
            <div class="card mb-4">
			  <div class="card-header">Blog</div>
                <div class="card-body">

					<div class="table-responsive">
						<table class="table table-bordered" id="records_table">
						<thead>    
							<tr>
								<th>Id</th>
								<th>Date</th>
								<th>Title</th>
								<th>Action</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
						</table>					
					</div>
					
                </div>
            </div>
			
			<div class="modal fade" id="viewModel" tabindex="-1">
				<div class="modal-dialog modal-lg">
					<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">View</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
					<div class="table-responsive">
						<table class="table table-bordered">
						<tbody id="model_table">
						</tbody>
						</table>					
					</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
					</div>
					</div>
				</div>
			</div>

        </div>
    </main>

<script type="text/javascript">
$(document).ready(function() {
<?php 
if(isset($_SESSION['dashboard']['message'])) {
	echo "toastr.options.positionClass = 'toast-bottom-right';".PHP_EOL;
	echo "toastr.success('".$_SESSION['dashboard']['message']."');".PHP_EOL;
	unset($_SESSION['dashboard']['message']); 
} ?>
 //datatables
    table = $('#records_table').DataTable({
        "processing": true,
        "serverSide": true,
		"autoWidth": false,
        "order": [],
		"lengthMenu": [[100, 200, 500, 1000], [100, 200, 500, 1000]],

        // Load data for the table's content from an Ajax source
        "ajax": ({
            url: "./ajax.php",
            type: "POST",
			dataType: "JSON",
			data: {'action':'list'},
        }),

        //Set column definition initialisation properties.
        "columnDefs": [
        { 
            "targets": [ 0, -1 ],
            "orderable": false,
        },
        ],
		"dom": "<'row'<'col'l><'col new'><'col'f>>" +
                "<'row'<'col-md-12'tr>>" +
                "<'row'<'col-md-6'i><'col-md-6'p>>",
		initComplete: function(){
			$("div.new").html('<a href="./add.php" title="Add New" class="btn btn-sm btn-primary"><i class="fas fa-plus"></i> Add New</a>');
		}
    });
});

// Table Reload
function reload_table() {
	table.ajax.reload(null,false);
}

// View
function view_row(id) {
    //Ajax Load data from ajax
    $.ajax({
        url : "./ajax.php",
        type: "POST",
        dataType: "JSON",
		data: {'action':'view', 'id':+ id},
        success: function(data) {
			var trHTML = '';
				trHTML += '<tr><td class="fw-bold">Post Date</td><td>' + data.col.date + '</td></tr>';
				trHTML += '<tr><td class="fw-bold">Title</td><td>' + data.col.title + '</td></tr>';
				trHTML += '<tr><td class="fw-bold">Content</td><td>' + data.col.content + '</td></tr>';
			$('#model_table').empty();
			$('#model_table').append(trHTML);
            $('#viewModel').modal('show');
        },
        error: function (jqXHR, textStatus, errorThrown)
        {
            alert('Error get data from ajax');
        } 
    });
}

// Delete row
function delete_row(id) {
    if(confirm('Are you sure delete this data?')) {
        // ajax delete data to database
        $.ajax({
            url : "./ajax.php",
            type: "POST",
            dataType: "JSON",
			data: {'action':'delete', 'id':id},
            success: function(data) {
				if(data.status == false) { 
					alert(data.msg);
				} else {
					reload_table();
					toastr.options.positionClass = 'toast-bottom-right';
					toastr.success(data.msg);
				}
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error deleting data');
            }
        });
    }
}
</script> 
 <?php include("../__footer.php"); ?>