<?php
session_start();
include("../config.php");
include(appPath."/includes/auth.php");
require_once(appPath."/includes/dbconn.php");

$pageTitle = "User Activity";
include("../__header.php");
include("../__menu.php");
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4"><?=$pageTitle;?></h1>
            <div class="card mb-4">
			  <div class="card-header">Users QR Code</div>
                <div class="card-body">
					<div class="table-responsive">
						<table class="table table-bordered" id="records_table">
						<thead>    
							<tr>
								<th>Id</th>
								<th>Date</th>
								<th>User</th>
								<th>Content</th>
								<th>Action</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
						</table>
					</div>
                </div>
            </div>
			
			<div class="modal fade" id="viewModel" tabindex="-1">
				<div class="modal-dialog modal-lg">
					<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">view</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
					<div class="table-responsive">
						<table class="table table-bordered">
						<tbody id="model_table">
						</tbody>
						</table>
						<div class="d-flex justify-content-center">
							<div class="w-50" id="qrcode-container"></div>
						</div>					
					</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
					</div>
					</div>
				</div>
			</div>

        </div>
    </main>
<script type="module">
import {QRCode} from '../js-qrcode/src/index.js';
window.QRCode = QRCode;
</script>
<script type="text/javascript">
$(document).ready(function() {
<?php 
if(isset($_SESSION["dashboard"]['message'])) {
	echo "toastr.options.positionClass = 'toast-bottom-right';".PHP_EOL;
	echo "toastr.success('".$_SESSION["dashboard"]['message']."');".PHP_EOL;
	unset($_SESSION["dashboard"]['message']); 
} ?>
 //datatables
    table = $('#records_table').DataTable({
        "processing": true,
        "serverSide": true,
		"autoWidth": false,
        "order": [],
		"lengthMenu": [[100, 200, 500, 1000], [100, 200, 500, 1000]],

        // Load data for the table's content from an Ajax source
        "ajax": ({
            url: "./ajax.php",
            type: "POST",
			dataType: "JSON",
			data: {'action':'list'},
        }),

        //Set column definition initialisation properties.
        "columnDefs": [
        { 
            "targets": [ 0, -1 ],
            "orderable": false,
        },
        ],
    });
});

// Table Reload
function reload_table() {
	table.ajax.reload(null,false);
}

// View
function view_row(id) {
    //Ajax Load data from ajax
    $.ajax({
        url : "./ajax.php",
        type: "POST",
        dataType: "JSON",
		data: {'action':'view', 'id':+ id},
        success: function(data) {
			var trHTML = '';
				trHTML += '<tr><td class="fw-bold">Date</td><td>' + data.col.date + '</td></tr>';
				trHTML += '<tr><td class="fw-bold">User</td><td>' + data.col.email + '</td></tr>';
				trHTML += '<tr><td class="fw-bold">Content</td><td><pre>' + data.col.content + '</pre></td></tr>';
				trHTML += '<tr><td class="fw-bold">Share This</td><td><h5><a href="../../share.php?id=' + data.col.shareId + '" target="_blank"><span class="badge bg-warning">Share</span></a></h5></td></tr>';
			$('#model_table').empty();
			$('#model_table').append(trHTML);
			
			// QR image
			let qrcode = (new QRCode()).render(data.col.content);
			// append it to the DOM
			let img = document.createElement('img');
			img.alt = 'QRCode';
			img.src = qrcode
			$('#qrcode-container').empty();
			document.getElementById('qrcode-container').appendChild(img);

            $('#viewModel').modal('show');
        },
        error: function (jqXHR, textStatus, errorThrown)
        {
            alert('Error get data from ajax');
        } 
    });
}

// Delete row
function delete_row(id) {
    if(confirm('Are you sure delete this data?')) {
        // ajax delete data to database
        $.ajax({
            url : "./ajax.php",
            type: "POST",
            dataType: "JSON",
			data: {'action':'delete', 'id':id},
            success: function(data) {
				if(data.status == false) { 
					alert(data.msg);
				} else {
					reload_table();
					toastr.options.positionClass = 'toast-bottom-right';
					toastr.success(data.msg);
				}
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error deleting data');
            }
        });
    }
}
</script> 
 <?php include("../__footer.php"); ?>