<?php
session_start();
include("../config.php");
include(adminPath."/includes/auth.php");
require_once(appPath."/includes/dbconn.php");

$tableName1 = "site_users";

if(!isset($_POST['action'])) {
	header("HTTP/1.1 403 Forbidden" );
	die('Forbidden');
}

function validate() {
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($_POST['username'] == '') {
			$data['inputerror'][] = 'username';
			$data['error_string'][] = 'Username required';
			$data['status'] = FALSE;
		}

		if($data['status'] === FALSE) {
			echo json_encode($data);
			exit();
		}
}

if($_POST['action'] == "list") {
	## Read value
	$start = $_POST['start'];
	$rowperpage = $_POST['length']; // Rows display per page
	if(isset($_POST['order'])) {
		$columnIndex = $_POST['order'][0]['column']; // Column index
		$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	} else {
		$columnIndex = '1';
		$columnName = 'id';
		$columnSortOrder = 'desc';
	}

	## Search
	$column_search = $db->rawQuery("SHOW COLUMNS FROM $tableName1");
	foreach($column_search as $fieds) {
		$colResult[] = $fieds['Field']; 
	}
	
	$searchQuery = "";
	if($_POST['search']['value']) {
		$i = 0;
		$searchQuery = "";
		foreach($colResult as $col) {
			if($i===0) { // first loop
				$searchQuery .= "AND ($col LIKE '%".$_POST['search']['value']."%' ";
			} else {
				$searchQuery .= "OR $col LIKE '%".$_POST['search']['value']."%' ";
			}
			if(count($colResult) - 1 == $i) { //last loop
				$searchQuery .= ")";
			}
			$i++;
		}
	}
	
	## Total number of records without filtering
	$records=$db->rawQueryOne("SELECT count(*) as allcount FROM $tableName1");
	$totalRecords = $records['allcount'];
	
	## Total number of record with filtering
	$records=$db->rawQueryOne("SELECT count(*) as allcount FROM $tableName1 WHERE 1 ".$searchQuery);
	$totalRecordwithFilter = $records['allcount'];
	
	## Fetch records
	$result=$db->rawQuery("SELECT * FROM $tableName1 WHERE 1 ".$searchQuery." order by ".$columnName." ".$columnSortOrder." limit ".$start.",".$rowperpage);
	$data = array();
	foreach($result as $line) {
		$row = array();
		$row[] = $line['id'];
		$row[] = $line['date'];
		$row[] = $line['name'];
		$row[] = $line['email'];
		$row[] = $line['block'];
		//add html for action
		$row[] = '<div class="btn-group btn-group-sm">
			<a href="javascript:void(0)" title="View" onclick="view_row('."'".$line['id']."'".')" class="btn btn-primary"><i class="fas fa-eye"></i></a>
			<a href="edit.php?id='.$line['id'].'" title="Edit" class="btn btn-success"><i class="fas fa-edit"></i></a>
			<a href="javascript:void(0)" title="Delete" onclick="delete_row('."'".$line['id']."'".')" class="btn btn-danger"><i class="fas fa-times-circle"></i></a>
			</div>';
		$data[] = $row;
	}

	## Response
	$output = array(
		"draw" => $_POST['draw'],
		"recordsTotal" => $totalRecords,
		"recordsFiltered" => $totalRecordwithFilter,
		"data" => $data,
					);
	//output to json format
	echo json_encode($output);

//ajax view
} elseif($_POST['action'] == "view") {
	$row_id=$_POST['id'];
	$result=$db->rawQueryOne("SELECT * from  $tableName1 WHERE id=".$row_id."");
	$output['col'] = $result;
	echo json_encode($output);

//ajax delete
} elseif($_POST['action'] == "delete") {
	if(isset($_POST['id'])) {
		$db->where('id', $_POST['id']);
		$db->delete("$tableName1");
		echo json_encode(array("status" => TRUE, "msg" => "Record Deleted"));
	} else {
		echo json_encode(array("status" => FALSE, "msg" => "Error"));
	}

//ajax update
} elseif($_POST['action'] == "update") {
		if($_POST['id'] != "") {
			$name = $_POST['name'];
			$email = $_POST['email'];
			$password = $_POST['password'];
			$block = $_POST['block'];

			$data = Array ( 'name' => $name, 'password' => "$password", 'email' => "$email", 'block' => "$block");
			$db->where('id', $_POST['id']);
			$db->update('site_users', $data);
			$_SESSION["dashboard"]["message"] = "Data updated successfully";
			echo json_encode(array("status" => TRUE, "msg" => "Success"));
		} else {
			echo json_encode(array("status" => FALSE, "msg" => "Error"));
		}

//ajax delete
} elseif($_POST['action'] == "delete") {
	if(isset($_POST['id'])) {
		$db->where('id', $_POST['id']);
		$db->delete("$tableName1");
		$db->rawQueryOne("DELETE FROM users_qrcode WHERE userId='".$_POST['id']."'"); // delete this user qr codes also.
		echo json_encode(array("status" => TRUE, "msg" => "Record Deleted"));
	} else {
		echo json_encode(array("status" => FALSE, "msg" => "Error"));
	}
	
//ajax add
} elseif($_POST['action'] == "add") {
		if($_POST['email'] != "") {
			$name = $_POST['name'];
			$email = $_POST['email'];
			$password = $_POST['password'];

			$data = Array ( 'name' => $name, 'password' => "$password", 'email' => "$email", 'block' => "No", 'date' => "$date");
			$db->insert('site_users', $data);
			$_SESSION["dashboard"]["message"] = "Data added successfully";
			echo json_encode(array("status" => TRUE, "msg" => "Success"));
		} else {
			echo json_encode(array("status" => FALSE, "msg" => "Error"));
		}

//ajax error
}	else { 
	echo json_encode("Error");
}
?>