<?php
session_start();
include("config.php");
include("includes/auth.php");
require_once(appPath."/includes/dbconn.php");

$pageTitle = "Home";
include("__header.php");
include("__menu.php");
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Home</h1>
            <div class="card mb-4">
			  <div class="card-header">Generate QR Code</div>
                <div class="card-body">
					<div class="row">
						<div class="col-md-6">
						<h2 class="mb-5">Content</h2>
					<form action="#" method="POST" id="form">
						<input type="hidden" value="add" name="action"/>
                        <div class="form-floating mb-3 col-sm-6">
							<textarea rows="5" class="form-control h-100" id="content" name="content"></textarea>
							<label for="content">Type Here</label>
							<span id="content_error" class="help-block text-warning"></span>
                        </div>
						<div class="mb-2">
							<button type="submit" id="btnSave" name="submit" class="btn  btn-success"><i class="fa fa-save"></i> Save</button>
							<button type="button" id="clear" class="btn btn-warning"><i class="fas fa-times-circle"></i> Clear</button>
						</div>											
					</form>
						</div>
						<div class="col-md-6">
						<h2 class="mb-1">Preview</h2>
						<div class="d-flex justify-content-start">
							<div class="w-75" id="qrcode-container"><span style="font-size:10vw"><i class="fas fa-qrcode"></i></span></div>
						</div>      
						</div>
					</div>
                </div>
            </div>
        </div>
    </main>
<script type="module">
import {QRCode} from './js-qrcode/src/index.js';
window.QRCode = QRCode;
</script>
<script type="text/javascript">
$(document).ready(function() {
//preview qr
      $("#content").on('keyup', function() {
        var content = $("#content").val();
			// QR image
			let qrcode = (new QRCode()).render(content);
			// append it to the DOM
			let img = document.createElement('img');
			img.alt = 'QRCode';
			img.src = qrcode
			$('#qrcode-container').empty();
			document.getElementById('qrcode-container').appendChild(img);
      });
//clear form
	$('#clear').click(function(){
        $('#content').val('');
	});
});

//post form data
$("#form").submit(function(event) {
    event.preventDefault();
    $('#btnSave').attr('disabled',true);
	
    // ajax adding data to database
    $.ajax({
        url : "./activity/ajax.php",
        type: "POST",
        data: $('#form').serialize(),
        dataType: "JSON",
        success: function(data)
        {
            if(data.status)  {
				toastr.options.onHidden = function() { 
					$('#btnSave').attr('disabled',false);
				}
				toastr.options.positionClass = 'toast-bottom-right';
				toastr.success('<h4>Saved Successfully. <a href="./share.php?id=' + data.shareId + '" target="_blank"><span class="badge bg-warning">Share</span></a></h4>');
            } else {
				$('#btnSave').attr('disabled',false);
                for (var i = 0; i < data.inputerror.length; i++) {
                    $('#'+data.inputerror[i]+'_error').text(data.error_string[i]);
                }
			}
        },
        error: function (jqXHR, textStatus, errorThrown)
        {
            alert('Error update data');
            $('#btnSave').attr('disabled',false);
        }
    });
});
</script>	
<?php include("__footer.php"); ?>