<?php
if(!isset($_SESSION)) {
     session_start();
}

$expireAfter = 30;
//Check to see if our "last action" session variable has been set.
if(isset($_SESSION['last_action'])){
    //Figure out how many seconds have passed since the user was last active.
    $secondsInactive = time() - $_SESSION['last_action'];

    //Convert our minutes into seconds.
    $expireAfterSeconds = $expireAfter * 60;

    //Check to see if they have been inactive for too long.
    if($secondsInactive >= $expireAfterSeconds){
        //User has been inactive for too long.
        //Kill their session.
        session_unset();
        session_destroy();
    }
}

$_SESSION['last_action'] = time();

// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== 'siteUser') {
	header("location: $appDir/login.php");
    exit;
}
?>