<?php
session_start();
include("config.php");
require_once("includes/dbconn.php");

if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] == 'siteUser'){
	echo '<script>window.location.href="./home.php";</script>';
	exit;
}
//login with user name and password
$message = "";
if(isset($_POST['submit'])) {
	if($_SESSION['captcha'] == $_POST['captcha']) {
		$name = $_POST["name"];
		$email = trim($_POST["email"]);
		$password = pass_encrypt($_POST["password"]);
		if($name == "" || $email == "" || $password == "") { 
			$message = '<div class="alert alert-danger" role="alert"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> Invalid Request</div>';
			exit;
		}
		$userdata = $db->rawQueryOne("SELECT * FROM site_users WHERE email='".$email."'");
		if ($db->count > 0) {
			$message = '<div class="alert alert-danger" role="alert"><i class="fas fa-user" aria-hidden="true"></i> Account already exist</div>';
		} else {
			$data = Array('name' => "$name", 'email' => "$email", 'password' => "$password", 'block' => "No", 'date' => "$date");
			$lastid = $db->insert('site_users', $data);
			$message = '<div class="alert alert-success" role="alert"><i class="fas fa-user" aria-hidden="true"></i> Account Created Sucessfully <a href="login.php">Login Here</a></div>';
		}
	} else {
		$message = '<div class="alert alert-danger" role="alert"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> Incorrect Captcha</div>';
	}
}
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title><?=$siteTitle?> | Create Account</title>
        <link href="<?=$appDir?>/assets/css/styles.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.1/css/all.min.css">
		<script src="<?=$appDir?>/assets/js/jquery.min.js"></script>
		<script src="<?=$appDir?>/assets/js/bootstrap.bundle.min.js"></script>
    </head>
    <body class="bg-primary">
        <div id="layoutAuthentication">
            <div id="layoutAuthentication_content">
                <main>
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-lg-5">
                                <div class="card shadow-lg border-0 rounded-lg mt-4">
									<div class="card-header"><h3 class="text-center font-weight-light my-2"><?=$siteTitle?> Create Account</h3></div>
                                    <div class="card-body">
                                         <form id="registerbox" method="POST">
                                            <div class="form-floating mb-3">
                                                <input class="form-control" id="name" type="text" name="name" placeholder="Your Name" />
                                                <label for="name">Name*</label>
                                            </div>
                                            <div class="form-floating mb-3">
                                                <input class="form-control" id="inputEmail" type="email" name="email" placeholder="name@example.com" />
                                                <label for="inputEmail">Email address*</label>
                                            </div>
                                            <div class="row mb-1">
                                                <div class="col-md-6">
                                                    <div class="form-floating mb-1 mb-md-0">
                                                        <input class="form-control" id="inputPassword" type="password" name="password" placeholder="Create a password" />
                                                        <label for="inputPassword">Password*</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-floating mb-1 mb-md-0">
                                                        <input class="form-control" id="inputPasswordConfirm" type="password" placeholder="Confirm password" />
                                                        <label for="inputPasswordConfirm">Confirm Password*</label>
                                                    </div>
                                                </div>
                                            </div>
											<div id="CheckPasswordMatch">Password must 8 characters long</div>
                                            <div class="mb-3 mt-2">
											<div class="" style="display:none" id="loadingDiv"><img style="width:50px" src="./assets/img/loading.gif"></div>
                                               <img src="captcha.php" style="width: 200px;" id="cpImage">
                                            </div>
                                            <div class="form-floating mb-3">
                                                <input type="text" class="form-control" id="inputcaptcha" placeholder="Enter captcha text" name="captcha"/>
												<label for="inputcaptcha">Captcha*</label>
                                            </div>
											<div class="error"><?=$message?></div>
                                            <div class="mt-4 mb-0 d-grid">
                                                <input type="submit" class="btn btn-lg btn-primary" name="submit" value="Create Account">
                                            </div>
                                        </form>
                                    </div>
                                    <div class="card-footer text-center py-3">
                                        <div class="small"><a href="login.php">Have an account? Go to login</a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
            </div>
            <div id="layoutAuthentication_footer">
                <footer class="py-3 bg-light mt-auto">
                    <div class="container-fluid px-4">
                        <div class="d-flex align-items-center justify-content-between small">
                            <div class="text-muted"><?=$version?></div>
							<div class="text-muted"><a class="link-secondary" href="<?=$appDir;?>/index.php">Home</a></div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
<script type="text/javascript">
    $(document).ready(function() {
      $("#inputPasswordConfirm").on('keyup', function() {
        var password = $("#inputPassword").val();
        var confirmPassword = $("#inputPasswordConfirm").val();
        if (password != confirmPassword) {
          $("#CheckPasswordMatch").html("Password does not match !").css("color", "red");
        } else {
          $("#CheckPasswordMatch").html("Password match !").css("color", "green");
		}
      });
    });
//captcha	
$("#cpImage").click(function(){
	$('#loadingDiv').show();
	$(this).hide();
	$(this).attr("src","./captcha.php?r=" + Math.random());
	$(this).on('load', function(){
		$('#loadingDiv').hide();
		$(this).show();
	});
});
// form submit
$('#registerbox').submit(function(event){
	if($('#inputPassword').val().length < 8 ) {
		event.preventDefault();
		$('.error').html('<div class="alert alert-danger" role="alert">Password must 8 characters long</div>');
	}
   $('#registerbox').find('input').each(function(){
		if($(this).val().length === 0 ) {
			event.preventDefault();
			$('.error').html('<div class="alert alert-danger" role="alert">Please enter all inputs</div>');
		}
	});
});
</script>
<script src="<?=$appDir?>/assets/js/scripts.js"></script>
    </body>
</html>